function createArmyKadirCamp()
	CampArmy = UnlimitedArmy:New({
		Player = 7,
		Area = 3200,
		AutoDestroyIfEmpty = true,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		LeaderFormation = 4,
		AIActive = true,
		AutoRotateRange = 1000000,
		DoNotNormalizeSpeed = true
		})
	CampArmySpawner = UnlimitedArmySpawnGenerator:New(CampArmy,{
							Position = GetPosition("KadirTruppen"),
							ArmySize = 10,
							SpawnCounter = 90,
							SpawnLeaders = 10,
							LeaderDesc = {
							{LeaderType = Entities.PU_LeaderSword3, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderPoleArm3, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PU_LeaderBow3, SoldierNum = 8, SpawnNum = 2, Looped = true, Experience = 3},
							{LeaderType = Entities.PV_Cannon3, SoldierNum = 0, SpawnNum = 2, Looped = true, Experience = 3}
							},
							Generator = "KadirSpawn"
							})
	CampArmy:AddCommandDefend(GetPosition("KadirTruppenDef"),4000,true)
	StartSimpleJob("GridDeleter")

end

function GridDeleter()
	local KadirEntities = {Logic.GetAllPlayerEntities(7, 40)}
	if KadirEntities[1] <= 1 then
		for i = 1,3,1 do
			DestroyEntity("Grid"..i)
		end
		return true
	end
	return false
end